﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using System.Xml.Linq;
using UnityEngine;

//BuildingsInstance represents a parsed key building from the XML
public class BuildingInstance
{
    public string ID { get; private set; }
    public string ModelID { get; private set; }

    public BuildingInstance()
    {

    }

    public bool Parse(XElement buildingInstanceElem)
    {
        try
        {
            ID = buildingInstanceElem.Attribute("ID").Value;
            ModelID = buildingInstanceElem.Attribute("ModelID").Value;
            return true;
        }

        catch (Exception ex)
        {
            Debug.LogError("ERROR: Caught an exception when parsing building instance element. The exception is: " + ex);
            return false;
        }
    }
}